<?php defined('PF_VERSION') OR exit('Access denied');?>
<?php
/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (mrtrungit@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
define("P", "position");
define("W", "widget");
define('PLUGIN_DASHBOARD', __('Dashboard', 'dashboard'));

class Dashboard_Plugin extends Pf_Plugin
{

    public $name = PLUGIN_DASHBOARD;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the Dashboard description';
    public $config;

    public function __construct()
    {
        
    }

    public function activate()
    {
        update_option('dashboard', array());
    }

    public function deactivate()
    {
        delete_option('dashboard');
    }

    public function insert_calendar()
    {
        $default_layout = get_default_layout();
        $data = get_option('dashboard');
        $id = current_user('user-id');
        if (!count($data)) {
            $data = array();
            $data[$id] = array(
                'id' => $id,
                'data' => array(),
                'layout' => $default_layout
            );
            update_option('dashboard', $data);
        } else {
            if (!isset($data[$id])) {
                $data[$id] = array(
                    'id' => $id,
                    'data' => array(),
                    'layout' => $default_layout
                );
                update_option('dashboard', $data);
            }
        }
    }

    public function admin_init()
    {
        include_once "dashboard-helper.php";
        if (is_login()) {
            $this->insert_calendar();
        }
        $this->admin_menu('fa fa-dashboard', __('Dashboard', 'dashboard'), 'dashboard', 'plugin_dashboard_manager');
    }

    public function plugin_dashboard_manager()
    {
        $this->js('admin/themes/default/assets/bootstrap-notification/js/jquery/jquery.easing.1.3.js');
        $this->js('admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js');
        $this->js('includes/common/plugin/assets/base.js?t=95');

        //Fancy box
        $this->js('media/assets/fancybox/jquery.fancybox-1.3.6.pack.js', __FILE__);
        $this->css('media/assets/fancybox/jquery.fancybox-1.3.6.css', __FILE__);

        $this->js('admin/plugins/dashboard/assets/validate-base.js');
        $this->js('admin/plugins/dashboard/assets/dashboard.js');
        $this->js('admin/plugins/dashboard/assets/dashboard-sortable.js');
        $this->css('admin/plugins/dashboard/assets/dashboard.css');
        $this->js('admin/plugins/dashboard/assets/fullcalendar.min.js');
        $this->css('admin/plugins/dashboard/assets/fullcalendar.css');
        $this->js('admin/plugins/dashboard/assets/bootbox.min.js');
        //Datetimepicker
        $this->js('admin/plugins/dashboard/assets/moment.js');
        $this->js('admin/plugins/dashboard/assets/bootstrap-datetimepicker.js');
        $this->css('admin/plugins/dashboard/assets/bootstrap-datetimepicker.css');

        $this->css('admin/plugins/dashboard/assets/alert.css');


        require_once abs_plugin_path(__FILE__) . '/dashboard/include/pf-dashboard.php';
        require_once abs_plugin_path(__FILE__) . '/dashboard/index.php';
    }

}
